function Supprimer-Element {
    param (
        [string]$cheminElement
    )

    if (Test-Path $cheminElement) {
        if (Test-Path -PathType Container $cheminElement) {
            Remove-Item -Recurse -Force $cheminElement
            Write-Host "Dossier supprim"
        } else {
            Remove-Item -Force $cheminElement
            Write-Host "Fichier supprim"
        }
    } else {
        Write-Host "lment introuvable : $cheminElement"
    }
}


$cheminRacineJeu = "C:\Program Files (x86)\Steam\steamapps\common\Lethal Company"
if (-not (Test-Path $cheminRacineJeu -PathType Container)) {
    $cheminRacineJeu = Read-Host "Entrez le chemin de votre jeu (ex: 'D:\Jeux\Steam\steamapps\common\Lethal Company') "
}

if (-not (Test-Path $cheminRacineJeu -PathType Container)) {
    Write-Host "Le dossier Lethal Comany n'a pas t trouv"
    Pause
    Exit
}

if (Test-Path $cheminRacineJeu -PathType Container) {
    $filesName = @('BepInEx', 'BoomboxController', 'doorstop_config.ini', 'winhttp.dll', 'version.txt')


    foreach ($element in $filesName) {
        $cheminDestination = Join-Path $cheminRacineJeu $element

        Supprimer-Element -cheminElement $cheminDestination

    }

    Write-Host "Modpack dsinstall avec succs !"
} else {
    Write-Host "Une erreur est survenu lors de la dsinstallation"
}

Pause